<?php get_header('custom'); 

// get the current taxonomy term
$term = get_queried_object();

// vars
$bg = get_field('background', $term)['url'];
$icon = get_field('icon', $term)['url'];

?>

<section class="case-block container-padding top-section">

    <div class="section-title" style="background-image:url('<?php echo $bg; ?>');">
        <div class="icon-image">
            <div class="outer-circle">
                <div class="inner-circle">
                    <div class="icon"><img src="<?php echo $icon; ?>" alt="icon"></div>
                </div>
            </div>
        </div>
        <h2 class="title"><?php echo single_term_title(); ?></h2>
    </div>

    <div class="section-slider">
        
        <div class="slider-container container">
                <div class="row">
                    
                    
                    <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
                    
                    
                    
                    <div class="swiper-slide col-lg-4 col-md-4 col-xs-4 col-sm-12">
                        <div class="image-container" style="background-image:url('<?php if (has_post_thumbnail()) { the_post_thumbnail_url('large-size'); } else { echo get_stylesheet_directory_uri() . '/images/default.jpg';  } ?>');"><a href="<?php if(get_sub_field('alternative_link')){echo get_sub_field('alternative_link'); }else{ echo the_permalink(); } ?>"></a></div>
                        <div class="text-container">
                            <h3 class="title"><a href="<?php echo the_permalink(); ?>"><?php echo the_title(); ?></a></h3>
                            <div class="excerpt"><?php if(has_excerpt()) { echo the_excerpt(); }else { the_advanced_excerpt('length=1&finish=sentence&length_type=characters&ellipsis=&exclude_tags=img,p,strong,figure,video'); }  ?></div>
                        </div>
                    </div>
                    
                    <?php endwhile; the_posts_pagination(array('screen_reader_text' => ' ')); endif; ?>
                    
                    
                </div>
            
            
        </div>
    </div>
</section>

<?php get_footer('custom'); ?>