<?php
/*
	Template Name: Innovations
*/

get_header('custom'); ?>


<section class="innovation-banner container-padding" id="particles-js">
    <div class="container">
        <div class="row">
            <div class="col">
                <div class="page-title"><?php echo get_field('banner_title'); ?></div>
                <div class="sub-paragraph"><?php echo get_field('banner_content_1'); ?></div>
                <?php echo get_field('banner_content_2'); ?>
                <?php 
                    $side_image = explode("{:}", get_field('banner_image', get_the_ID(),false));
                    $langs = $side_image;

                    foreach ($langs as $lang) {
                        $phrase  = $side_image;
                        $healthy = array("{:en}", "{:ja}");
                        $yummy   = array("", "");

                        $newphrase = str_replace($healthy, $yummy, $phrase);
                    }
                    if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                ?>
                <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                  <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt="" class="floating-image"/>
                <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                  <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt="" class="floating-image"/>
                <?php } ?>
            </div>
        </div>
    </div>
</section>

<section class="innovation-committed container-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-12 content">
                <h2 class="title-teal"><?php echo get_field('committed_title'); ?></h2>
                <?php echo get_field('committed_content_1'); ?>
                <?php echo get_field('committed_content_2'); ?>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-12 image">
                <?php 
                    $side_image2 = explode("{:}", get_field('committed_image', get_the_ID(),false));
                    $langs = $side_image2;

                    foreach ($langs as $lang) {
                        $phrase  = $side_image2;
                        $healthy = array("{:en}", "{:ja}");
                        $yummy   = array("", "");

                        $newphrase = str_replace($healthy, $yummy, $phrase);
                    }
                    if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                ?>
                <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                  <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt=""/>
                <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                  <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt=""/>
                <?php } ?>
            </div>
        </div>
    </div>
</section>

<section class="innovation-tools container-padding">
    <div class="container">
        <div class="row">
            <div class="col"><h2 class="title-teal"><?php echo get_field('tools_title'); ?></h2></div>
        </div>
        <div class="row">
            <?php if( have_rows('tools') ): ?>
                <?php while( have_rows('tools') ): the_row(); ?>
                <div class="col-lg-4 col-md-4 col-sm-12">
                    <div class="img-wrap">
                        <?php 
                            $side_image3 = explode("{:}", get_sub_field('image', false));
                            $langs = $side_image3;

                            foreach ($langs as $lang) {
                                $phrase  = $side_image3;
                                $healthy = array("{:en}", "{:ja}");
                                $yummy   = array("", "");

                                $newphrase = str_replace($healthy, $yummy, $phrase);
                            }
                            if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                        ?>
                        <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt=""/>
                        <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                          <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt=""/>
                        <?php } ?>
                    </div>
                    <div class="title"><?php echo get_sub_field('title'); ?></div>
                    <?php echo get_sub_field('description'); ?>
                </div>
                <?php endwhile; ?>
            <?php endif; ?>
        </div>
    </div>
</section>

<section class="innovation-leverage container-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-12 content">
                <h2 class="title-teal"><?php echo get_field('leverage_title'); ?></h2>
                <?php echo get_field('leverage_content_1'); ?>
                <?php echo get_field('leverage_content_2'); ?>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-12 image">
                <?php 
                    $side_image4 = explode("{:}", get_field('leverage_image', get_the_ID(),false));
                    $langs = $side_image4;

                    foreach ($langs as $lang) {
                        $phrase  = $side_image4;
                        $healthy = array("{:en}", "{:ja}");
                        $yummy   = array("", "");

                        $newphrase = str_replace($healthy, $yummy, $phrase);
                    } 
                    if ($newphrase[1] == "") { $num = 0; } else { $num = 1; }
                ?>
                <?php if ( WPGlobus::Config()->language == 'ja' ) { ?>
                  <img src="<?php echo wp_get_attachment_url( ($newphrase[$num]) ); ?> " alt=""/>
                <?php } else if ( WPGlobus::Config()->language == WPGlobus::Config()->default_language ) { ?>  
                  <img src="<?php echo wp_get_attachment_url( ($newphrase[0]) ); ?> " alt=""/>
                <?php } ?>
            </div>
        </div>
    </div>
</section>

<?php echo get_template_part('parts/part', 'contact'); ?>
<?php get_footer('custom'); ?>