<?php
/*
	Template Name: Haptic Resources
*/

get_header('custom'); ?>

<section class="haptic-resource-title container-padding top-section" style="background-image:url('<?php echo get_field('banner'); ?>');">
    <div class="container">
        <div class="row">
            <div class="col text-center">
                <h1 class="page-title"><?php single_post_title(); ?></h1>
                <p><?php echo get_field('page_description'); ?></p>
            </div>
        </div>
    </div>
</section>

<section class="haptic-resource-articles-news">
    <div class="container haptic-resource-articles-news-container">
        <h5 class="haptic-resource-articles-news-title">Articles and News</h5>
        <div class="row haptic-resource-articles-news-row">
            <div class="col-lg-3 article-news-list-container">
                <?php 
                $terms = get_field('articles_categories');
                if( $terms ): ?>
                    <ul class="article-news-list">
                    <li><a href="#" class="active"><span class="text">All Articles</span> <span class="arrow">&#9660;</span></a></li>
                    <?php foreach( $terms as $term ): ?>
                        <li><a href="#" data-category="<?php echo get_cat_slug($term); ?>"><?php echo get_cat_name($term);?></a></li>
                    <?php endforeach; ?>
                    <li><a href="#" data-category="news"><span class="text">News</span></a></li>
                    </ul>
                <?php endif; ?>
            </div>
            
            <div class="article-news-panel-container col-lg-9">
                <div class="row article-news-panel-container-row">
                    
                <?php 
                    $terms = get_field('articles_categories');
                    
                    // foreach( $terms as $term ) :
                    //     var_dump($term);
                    //     endforeach; // for terms
                    $postsargs = array(
                        'post_type'=> 'post', 
                        'post_status'=>'publish', 
                        // 'category__in' => array($term), 
                        'posts_per_page'=> -1,
                        'orderby' => 'date',
                        'order'   => 'DESC',
                        'tax_query' => array(
                            array(
                                'taxonomy' => 'category', //double check your taxonomy name in you dd 
                                'field'    => 'id',
                                'terms'    => $terms,
                            ),
                        ),
                    );
                    
                    $newsargs = array(
                        'post_type' => 'news',
                        'post_status'=>'publish', 
                        'posts_per_page'=> -1,
                        'orderby' => 'date',
                        'order'   => 'DESC',
                    );
                    
                    // var_dump($newsargs);
                    
                    // $the_query = new WP_Query();
                    $query1 = new WP_Query($postsargs);
                    $query2 = new WP_Query($newsargs);
                    
                    $the_query = new WP_Query(array(
                        'orderby'   => 'date', 
                        'order'     => 'DESC'
                    ));
                    $the_query->posts = array_merge($query1->posts,$query2->posts);
                    
                    $the_query->post_count = $query1->post_count + $query2->post_count;
                    
                    
                    if ( $the_query->have_posts() ) :
                    while ( $the_query->have_posts() ) : $the_query->the_post();
                    $display++;
                    $categories = get_the_category();
                    $cls = '';

                    if ( ! empty( $categories ) ) {
                        foreach ( $categories as $cat ) {
                            $cls .= $cat->slug . ' ';
                        }
                    }
                ?>
                <div class="article-news-panel col-lg-4 
                    <?php 
                        //echo $categories[0]->category_nicename;
                        if ( ! empty( $categories ) ) {
                            foreach ( $categories as $cat ) {
                                echo $cls .= $cat->slug . ' ';
                            }
                        } else {
                            echo 'news';
                        }
                    ?> 
                    <?php echo " resource-article-{$display}"?>
                ">
                    <a href="<?php the_permalink(); ?>">
                        <div class="article-news-panel-overlay"></div>
                        <div class="article-news-panel-category">
                            <span>
                                <?php
                                if ( ! empty( $categories ) ) { 
                                    echo $categories[0]->cat_name;
                                } else {
                                    echo 'News';
                                }
                                    
                                ?>
                            </span>
                        </div>
                        <div class="article-news-panel-img">
                            <?php 
                                if(has_post_thumbnail()){
                                    the_post_thumbnail();
                                }
                            ?>
                        </div>
                        <div class="article-news-panel-title">
                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        </div>
                    </a>
                </div>
                <?php wp_reset_postdata(); ?>
                <?php endwhile; ?>
                <?php endif; ?>
                <?php 
                    // endforeach; // for terms ?>
                </div>
                <div class="article-news-pagination-wrapper">
                    <div class="article-news-more-cta">
                        <p><a href="<?php echo get_site_url(); ?>/blog" class="arrow-link">More from our Blog</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="haptic-resource-technical">
    <div class="container">
        <h5 class="haptic-resource-technical-title">Technical Resources</h5>
        <div class="row haptic-resource-technical-row">
            <div class="col-lg-3 technical-list-container">
                <?php 
                $terms = get_field('technical_resources_categories');
                if( $terms ): ?>
                    <ul class="technical-list">
                    <li><a href="#" class="active"><span class="text">All Articles</span> <span class="arrow">&#9660;</span></a></li>
                    <?php foreach( $terms as $term ): ?>
                        <li><a href="#" data-category="<?php echo get_cat_slug($term); ?>"><?php echo get_cat_name($term);?></a></li>
                    <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </div>
            <div class="technical-panel-container col-lg-9">
                <div class="row technical-panel-container-row">
                <?php 
                    $terms = get_field('technical_resources_categories');
                    global $post;
                    // foreach( $terms as $term ) :
                    $args = array( 
                        'post_type' => 'technical_resources', 
                        'post_status'=>'publish', 
                        // 'category__in' => array($term), 
                        'posts_per_page'=>-1
                    );
                    $the_query = new WP_Query( $args );
                ?>
                <?php if ( $the_query->have_posts() ) : ?>
                <?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
                <?php $pdfurl = get_post_meta($post->ID, 'technical_resources_url', true); ?>
                <?php $c = get_the_category(); ?>
                <div class="col-lg-6 technical-panel <?php echo $c[0]->category_nicename; ?>">
                    <div>
                        <?php 
                            if(has_post_thumbnail()){
                                the_post_thumbnail();
                            }
                        ?>
                    </div>
                    <div class="technical-panel-description">
                        <h6><a href="<?php 
                            if($pdfurl) {
                                echo $pdfurl;
                            } else {
                                the_permalink(); 
                            }
                        ?>" target="<?php if($pdfurl) { ?>__blank<?php } ?>"><?php the_title(); ?></a></h6>
                        <p><?php the_excerpt(); ?></p>
                        <p><a href="<?php 
                            if($pdfurl) {
                                echo $pdfurl;
                            } else {
                                the_permalink(); 
                            }
                        ?>" target="<?php if($pdfurl) { ?>__blank<?php } ?>" class="arrow-link">Read the article</a></p>
                    </div>
                </div>
                <?php wp_reset_postdata(); ?>
                <?php endwhile; ?>
                <?php endif; ?>                                
                <?php // endforeach; // for terms ?>
                </div>
                <div class="article-news-pagination-wrapper">
                    <div class="article-news-more-cta">
                        <p><a href="<?php echo get_site_url(); ?>/technical-resources/" class="arrow-link">More technical resources</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="haptic-resource-video">
    <div class="container">
        <h5 class="haptic-resource-video-title">Video</h5>
        <div class="row haptic-resource-video-title-row">

            <?php 
                $args = array( 'post_type' => 'resource_video', 'posts_per_page'=>-1 );
                $the_query = new WP_Query( $args ); 
            ?>
            <?php if ( $the_query->have_posts() ) : ?>
            <?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
            <div class="video-panel col-lg-3">
                <a href="<?php the_permalink(); ?>">
                    <div class="video-panel-thumbnail">
                        <div class="video-panel-play">
                            <span>&#9658;</span>
                        </div>
                        <?php 
                            if(has_post_thumbnail()){
                                the_post_thumbnail();
                            }
                        ?>
                        <div class="video-title">
                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        </div>
                    </div>
                </a>
                <div class="video-panel-description">
                    <p><?php the_excerpt(); ?></p>
                </div>
            </div>
            <?php wp_reset_postdata(); ?>
            <?php endwhile; ?>
            <?php endif; ?>

            
        </div>
    </div>
</section>

<?php //echo get_template_part('parts/part', 'cta'); ?>
<?php get_footer('custom'); ?>