jQuery(document).ready(function($) {
    $(".navbar-toggle").click();
    
	function screen_width() {
		return $(window).width();
	}

	function screen_height() {
		return $(window).height();
	}

	function screen_position() {
		return window.pageYOffset;
	}

	function debounce(func, wait, immediate) {
		var timeout;
		return function() {
			var context = this, args = arguments;
			var later = function() {
				timeout = null;
				if (!immediate) func.apply(context, args);
			};

			var callNow = immediate && !timeout;
			clearTimeout(timeout);
			timeout = setTimeout(later, wait);
			if (callNow) func.apply(context, args);
		};
	}
    
    
    function textScroll() {
//        $(window).scroll(function(){
//            var dark_pos = $('.dark-bg').offset().top;
//            var dark_height = $('.dark-bg').height();
//            var menu_pos = $('.about-sidebar li a').offset().top;
//            var menu_height = $('.about-sidebar li a').height();
//            var scroll = $(window).scrollTop();
//
//            if(menu_pos > dark_pos && menu_pos < (dark_pos + dark_height)) {
//                $('.about-sidebar li a').addClass('menu_white');
//              $('.about-sidebar li a').removeClass('menu_black');
//            }
//            else {
//                $('.about-sidebar li a').removeClass('menu_white');
//              $('.about-sidebar li a').addClass('menu_black');
//            }
//          });
    }
    
//    function menuMobile() {
//        if ($(window).width() <= 1023) {
//            $('.menu-button').on('click', function(){
//                $('nav.menu').slideToggle('slow');
//                console.log('test');
//            });
//        }
//    }
    
    $(".menu-button").on("click", function(evt){
        $('nav.menu').slideToggle('slow');
        evt.stopImmediatePropagation();
    });
    
    
    function smoothScroll() {

        // direct browser to top right away
        if (window.location.hash)
            scroll(0,0);
        // takes care of some browsers issue
        setTimeout(function(){scroll(0,0);},1);

        $(function(){
        //your current click function
        $('.scroll').on('click',function(e){
//            e.preventDefault();
            $('html,body').animate({
                scrollTop:$($(this).attr('href')).offset().top
            },1000,'swing');
        });

        // if we have anchor on the url (calling from other page)
        if(window.location.hash){
            // smooth scroll to the anchor id
            $('html,body').animate({
                scrollTop:$(window.location.hash).offset().top
                },1000,'swing');
            }
        });
        
    }   
    
    function homeNav() {
        $(window).scroll(function() {
             if ($(document).scrollTop() > 60) {
                $('.home header').addClass('shrink');
              } else {
                $('.home header').removeClass('shrink');
              }
        });
    }
    
    /*
	 *  Functions that must be called when window resizes.
	 */
    
//    $(window).resize(debounce(function(){
//        
//            menuMobile();
//        
//	}, 250));
    
    /*
	 *  Functions that must be called after the page loads
	 */
    
    homeNav();
    textScroll();
    smoothScroll();
//    menuMobile();
    
    
//    var swiper = new Swiper('.swiper-container', {
//        slidesPerView: 3,
//        spaceBetween: 30,
//        navigation: {
//            nextEl: '.swiper-button-next-0',
//            prevEl: '.swiper-button-prev-0',  
//          },
//        preventClicks: false,
//        breakpoints: {
//            860: {
//                slidesPerView: 2,
//                spaceBetween: 30,
//            },
//            580: {
//                slidesPerView: 1,
//                spaceBetween: 0,
//            }
//        }
//    });
    
});