jQuery(document).ready(function($) {
    $(".navbar-toggle").click();
    
	function screen_width() {
		return $(window).width();
	}

	function screen_height() {
		return $(window).height();
	}

	function screen_position() {
		return window.pageYOffset;
	}

	function debounce(func, wait, immediate) {
		var timeout;
		return function() {
			var context = this, args = arguments;
			var later = function() {
				timeout = null;
				if (!immediate) func.apply(context, args);
			};

			var callNow = immediate && !timeout;
			clearTimeout(timeout);
			timeout = setTimeout(later, wait);
			if (callNow) func.apply(context, args);
		};
	}
    
    $(".menu-button").on("click", function(evt){
        $('nav.menu').slideToggle('slow');
        evt.stopImmediatePropagation();
    });
    
    function smoothScroll() {

        //* Direct browser to top right away
        if (window.location.hash)
            scroll(0,0);
        //* Takes care of some browsers issue
        setTimeout(function(){scroll(0,0);},1);

        $(function(){
        //* Your current click function
        $('.scroll').on('click',function(e){
            $('html,body').animate({
                scrollTop:$($(this).attr('href')).offset().top
            },1000,'swing');
        });

        //* If we have anchor on the url (calling from other page)
        if(window.location.hash) {
            //* Smooth scroll to the anchor id
            $('html,body').animate({
                scrollTop:$(window.location.hash).offset().top
                }, 1000,'swing');
            }
        });
        
    }   
    
    function homeNav() {
        $(window).scroll(function() {
            if ($(document).scrollTop() > 60) {
                $('.home header').addClass('shrink');
            } else {
                $('.home header').removeClass('shrink');
            }
        });
    }
    
    /*
	 *  Functions that must be called when window resizes.
	 */
    
   $(window).resize(function() {
        $('nav').removeAttr('style');
	});
    
    /*
	 *  Functions that must be called after the page loads
	 */
    
    homeNav();
    smoothScroll();
    Detectizr.detect({
        detectScreen: false,
        detectBrowser: true
    });

    /*
     *  Trigger search function
     */
    
    $('header .search-button, .search-window .close').on('click', function() {
        $('.search-window').toggleClass('active');
    });
    
    
    $(window).resize(function(){
        if($(window).width() > 768) {
            $('.flex-box.haptics, .flex-box.six-content').matchHeight();
        } else {
            $('.flex-box.haptics, .flex-box.six-content').matchHeight({
                remove: true
            });
        }
    });
    $(window).trigger('resize');
    
    
    
});