<?php
/*
 * Plugin Name: WPGlobus Header Images
 * Plugin URI: https://wpglobus.com/product/wpglobus-header-images/
 * Description: Display different header images per language. Show images depending on the settings in customizer.
 * Text Domain: wpglobus-header-images
 * Domain Path: /languages/
 * Version: 2.2.0
 * Author: WPGlobus
 * Author URI: https://wpglobus.com/
 * License: GPL-3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'plugins_loaded', 'wpglobus_header_images_load', 11 );
function wpglobus_header_images_load() {

	/**
	 * Main WPGlobus plugin is required.
	 */
	if ( ! defined( 'WPGLOBUS_VERSION' ) ) {
		return;
	}

	define( 'WPGLOBUS_HEADER_IMAGES_VERSION', '2.2.0' );

	load_plugin_textdomain( 'wpglobus-header-images', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );

	require_once dirname( __FILE__ ) . '/includes/class-wpglobus-header-images.php';
	WPGlobus_Header_Images::construct( __FILE__ );

}

/**
 * Setup updater.
 */
function wpglobus_header_images__setup_updater() {
	/* @noinspection PhpUndefinedClassInspection */
	new TIVWP_Updater( array(
		'plugin_file' => __FILE__,
		'product_id'  => 'WPGlobus Header Images',
		'url_product' => 'https://wpglobus.com/product/wpglobus-header-images/',
	) );
}

add_action( 'tivwp_updater_factory', 'wpglobus_header_images__setup_updater' );

/*EOF*/
