/**
 * WPGlobus Header Images
 * Interface JS functions
 *
 * @since 1.0.0
 *
 * @package WPGlobus Header Images
 */
/*jslint browser: true*/
/*jshint sub:true*/
/*global jQuery, console, WPGlobusAdmin, WPGlobusHeaderImages:true*/
jQuery(document).ready(function ($) {
    "use strict";

    var api;
    if (typeof WPGlobusHeaderImages === 'undefined') {
        return;
    }

    if (typeof WPGlobusAdmin === 'undefined') {
        return;
    }

	window.WPGlobusHeaderImagesStickers = function( args ){
		this.keys 		= [];
		this.keyIndex 	= {};
		this.sticker 	= {};
		this.option;
		if ( 'undefined' === typeof args || args == null ) {
			this.option = null;
		} else {
			this.option = {};
			for( var k in args) { 
				this.option[k] = args[k]; 
			}				
		}	
	};
	WPGlobusHeaderImagesStickers.prototype.set = function(key, args){
		if ( 'undefined' === typeof this.sticker[key] ) {
			this.keyIndex[key] = this.keys.length;
			this.keys.push(key);
		}	
		if ( 'undefined' === typeof args || args == null ) {
			this.sticker[key] = null;
		} else {	
			this.sticker[key] = {};
			for( var k in args) { 
				this.sticker[key][k] = args[k]; 
			}			
		}		
	};	
	WPGlobusHeaderImagesStickers.prototype.reset = function(key){
		if ( 'undefined' !== typeof this.option.alwaysSelectable && key == this.option.alwaysSelectable ) {
			return false;
		}			
		if ( 'undefined' === typeof key ) {
			return false;	
		}
		this.sticker[key] = null;
	};
	WPGlobusHeaderImagesStickers.prototype.get = function(key){
		if ( 'undefined' === typeof key ) {
			return this.sticker;
		}	
		return this.sticker[key];
	};	
	WPGlobusHeaderImagesStickers.prototype.next = function(key){
		if ( 'undefined' === typeof this.keys[this.keyIndex[key] + 1] ) {
			return this.keys[0];
		}	
		return this.keys[this.keyIndex[key] + 1];
	};	
	WPGlobusHeaderImagesStickers.prototype.nextSelectable = function(key){

		var i = this.keyIndex[key] + 1,
			noStop 	= true, 
			j = 0,
			newKey = this.option.alwaysSelectable || undefined;

		do {
			if ( 'undefined' === typeof this.keys[i] ) {
				i = 0;	
			} 

			if ( this.keys[i] == key ) {
				noStop = false;
			} else {
				if ( this.sticker[ this.keys[i] ] == null ) {
					newKey  = this.keys[i];
					noStop = false;
				} else {	
					if ( this.sticker[ this.keys[i] ]['selectable'] ) {
						newKey = this.keys[i];
						noStop = false;
					}
				}	
			}	
			i += 1;
			j += 1
			if ( j > 20 ) noStop = false;
			
		} while ( noStop )

		return newKey;
	};	
	
    api = {
        promise	 	 : $.when(),
		stickerHtml  : '<span class="language-sticker" data-sticker-id="{{sticker-id}}" data-language="{{language}}">{{caption}}</span>',
		emptySticker : 'empty',
		stickers 	 : new WPGlobusHeaderImagesStickers({'alwaysSelectable':'empty'}),
		currentImageSticker : 'current_image',
		ajaxified    : false,
		listen		 : false,
        init: function () {
			
			if ( null == WPGlobusHeaderImages.themeOptions ) {
				$( WPGlobusHeaderImages.i18n.saveOptions.selector ).append( '<p class="wpglobus-warning-message">' + WPGlobusHeaderImages.i18n.saveOptions.message + '</p>' );
				return;	
			}
		
			var start = $.Deferred();
			start.resolve( api.leadUp() );
			
			api.promise = api.promise.then(function() {
				return $.when(
					start.done()
				)	
			}).then( function( result ) {
				
				api.stickers.set( api.currentImageSticker, {'selectable':false, 'status':'active'} );
				api.stickers.set( api.emptySticker, {'selectable':true, 'status':'active'} );
			
				$.each( WPGlobusCoreData.enabled_languages, function( i, lang ) {
					if ( lang == WPGlobusCoreData.default_language ) {
						api.stickers.set( lang, null );
					} else {
						if ( 'undefined' === typeof WPGlobusHeaderImages.options[ lang ] ) {
							api.stickers.set( lang, null );
						} else {	
							api.stickers.set( lang, WPGlobusHeaderImages.options[ lang ].sticker_data );
						}	
					}	
				});
				api.setStickerToCurrentImage();
				api.setStickers();
				if ( ! api.listen ) {
					api.listen = true;
					api.addListeners();
				}
			});


        },
		setStickerToCurrentImage: function() {
			/**
			 * By default current image has sticker with default language
			 */
			if ( api.hasCurrentImage() ) {	
				api.setSticker( 
					WPGlobusHeaderImages.imageCurrentSelector, 
					api.currentImageSticker, 
					WPGlobusCoreData.default_language 
				);
				/**
				 * Update option for src of new selected image.
				 */
				WPGlobusHeaderImages.themeOptions.header_image = $( WPGlobusHeaderImages.imageCurrentSelector + ' img' ).attr( 'src' );
				/** @todo WPGlobusHeaderImages.themeOptions.header_image_data */
				api.setStickerForDefaultLanguage();
			}		
		},
		setStickerForDefaultLanguage: function() {
			/**
			 * Check for existing sticker for default language
			 */
			var sticker = api.stickers.get( WPGlobusCoreData.default_language ); 
			if ( null !== sticker ) {
				$( sticker.selector ).remove();
				api.stickers.set( WPGlobusCoreData.default_language, null );
			}	
			
			/**
			 * Add new sticker for default language
			 */	
			$( WPGlobusHeaderImages.imagesSelector+'.wpglobus-header-view img' ).each( function(i,img){
				if ( api.getCurrentHeaderImage() == $(img).attr('src') ) {
					api.setSticker( 
						WPGlobusHeaderImages.imagesSelector + ':eq('+i+')',
						WPGlobusCoreData.default_language
					);
					return false;
				}
			});				
		},		
		getSticker: function( selector ) {
			var $s = $( selector );
			if ( $s.length == 0 ) {
				return false;
			}
			return $s.data( 'sticker-id' );
		},
		setStickers: function() {
			if ( api.hasCurrentImage() ) {	
				var sticker;
				$.each( WPGlobusHeaderImages.options, function( lang, obj ){
					api.setSticker( obj.sticker_data.parentSelector , obj.sticker );
				});
				$( WPGlobusHeaderImages.imagesSelector + '.wpglobus-header-view' ).each( function( i, e ) {
					sticker = api.getSticker( $(e).find( '.language-sticker' ) );
					if ( false === sticker ) {
						api.setSticker( $(this), api.emptySticker );
					}
				});
			}
		},		
		setSticker: function( selector, key, caption ) {
			if ( 'undefined' === typeof selector ) {
				return false;
			}
			if ( 'undefined' === typeof key || '' == key ) {
				key = 'empty';
			}
			if ( 'undefined' === typeof caption ) {
				caption = key;
			}
			
			var selectable 	= true,
				language	= '';
			
			if ( key != 'empty' ) {
				if ( key == WPGlobusCoreData.default_language ) {
					selectable = false;
					language 	= WPGlobusCoreData.default_language;	
				} else if ( key == api.currentImageSticker ) {
					selectable 	= false;
					language 	= WPGlobusCoreData.default_language;	
				} else {
					language	= key;	
					selectable 	= false;
				}	
				api.stickers.set( key, {
					'status'	: 'active',
					'selector'	: selector + ' .language-sticker',
					'parentSelector'	: selector,
					'selectable': selectable,
					'caption'	: caption,
					'language'	: language
				} );
			}
			
			/**
			 * Remove old sticker if it exists.
			 */
			$( selector ).find( '.language-sticker' ).remove();
			
			/**
			 * Apply sticker to header image. 
			 */
			$( selector ).prepend( api.getStickerHtml( key ) );	

			return api.stickers.get( key );	

		},	
		resetSticker: function( key ) {
			api.stickers.reset( key );
		},
		getStickerHtml: function( key ) {
			if ( 'undefined' === typeof key ) {
				return '';	
			}	
			var html = api.stickerHtml;
			if ( key == '' || key == 'empty' ) {
				key = api.emptySticker;	
				html = html.replace( /{{language}}/g, '' );
				html = html.replace( /{{caption}}/g,  '' );
				html = html.replace( /{{sticker-id}}/g,  key );
			} else {
				var sticker = api.stickers.get( key );	
				html = html.replace( /{{language}}/g, sticker.language );
				html = html.replace( /{{caption}}/g, sticker.caption )
				html = html.replace( /{{sticker-id}}/g,  key );
			}	
			return html;
		},
		leadUp: function() {
			/**
			 * Start the processing of images.
			 */
            var imgs = $( WPGlobusHeaderImages.imagesSelector ).length;	
			$( WPGlobusHeaderImages.imagesSelector ).each( function(i,img){
				if ( imgs == i + 1 ) {
					return false;
				}
				/**
				 * Add our class to every .header-view element.
				 * Add order attribute.
				 */
				$( img ).addClass( 'wpglobus-header-view' ).attr( 'data-wpglobus-order' , i );
			});
			
			/**
			 * Remove all old stickers if they exist.
			 */
			$( '.wpglobus-header-view' ).find( '.language-sticker' ).remove();
			
			api.getOptions();
		},		
		getCurrentHeaderImage: function() {
			if ( typeof WPGlobusHeaderImages.themeOptions !== 'undefined' ) {
				return WPGlobusHeaderImages.themeOptions.header_image;
			}
			return '';	
		},
		hasCurrentImage: function() {
			/**
			 * Check for existing image for Current header
			 */
			if ( $( WPGlobusHeaderImages.imageCurrentSelector ).find( '.placeholder' ).length > 0 ) {	
				return false;
			}
			return true;
		},	
		addListeners: function() {
			
			$( document ).on( 'click', WPGlobusHeaderImages.stickerSelector, function(ev){
				/**
				 * The select of extra languages for every images
				 */
				var sticker = $( this ).data( 'sticker-id' ), 
					language = $( this ).data( 'language' ); 
				
				if ( sticker == api.currentImageSticker ) {
					return;
				}	
				if ( language == WPGlobusCoreData.default_language ) {
					return;	
				}
						
				var nextSticker  = api.stickers.nextSelectable( sticker ),
					pr 	= $( this ).parent( 'div' ),
					imgOrder = pr.data( 'wpglobus-order' ),
					imgData  = pr.find( 'button.choice' ).data( 'customize-header-image-data' ),
					stickerData, stickerDataSave;
				
				if ( 'undefined' !== typeof imgOrder ) {
					api.resetSticker( sticker );
					stickerData 	= api.setSticker( WPGlobusHeaderImages.imagesSelector + ':eq('+imgOrder+')', nextSticker );
					stickerDataSave = jQuery.extend( {}, stickerData );

					/**
					 * Before save option we need to mask the real current order of image.
					 * @see getOptions()
					 */
					if ( 'undefined' !== typeof stickerData.selector ) {
						stickerDataSave.selector = stickerDataSave.selector.replace( imgOrder, '{{order}}' );
					}	
					if ( 'undefined' !== typeof stickerData.parentSelector ) {
						stickerDataSave.parentSelector 	= stickerDataSave.parentSelector.replace( imgOrder, '{{order}}' );
					}

					api.save( {
						'language'		: stickerDataSave.language,
						'sticker'		: nextSticker,
						'sticker_data'	: stickerDataSave,
						'img_data'		: imgData
					} );
				}
			});
			
			$( document ).ajaxComplete(function(event, jqxhr, settings){
				
				if ( api.ajaxified ) {
					return;
				}

				if ( 'undefined' === typeof settings.data ) {
					return;	
				}
				
				if ( -1 != settings.data.indexOf( 'action=custom-header-add' ) ) {
					/**
					 * Add new header image by clicking 'Add new image' button
					 */
					setTimeout( function(){
						//console.log( "Add new header image by clicking 'Add new image' button " );
						api.init();
					}, 2000 );
					return;
				} else if ( -1 != settings.data.indexOf( 'wp_customize=on' ) 
						&& -1 != settings.data.indexOf( 'header_image_data' ) 
						&& -1 == settings.data.indexOf( 'action=customize_save' ) ) {

					/**
					 * Switch header image by clicking at Previously uploaded image.
					 */	
					/**
					 * 'action=customize_save' has been set by clicking on Save&Publish button.
					 */	
					//console.log( "Switch header image by clicking at Previously uploaded image" );
					api.deleteOptions();
					api.init();
					return;
				} else if ( -1 != settings.data.indexOf( 'action=custom-header-remove' ) ) {
					/**
					 * Remove header image by clicking close button ( see at picture ).
					 */
					//console.log( "Remove header image by clicking close button" );
					api.promise = api.promise.then(function() {
						return api.ajax({'action':'delete_option','data':settings.data});
					});
					api.init();
					return;
				} else if ( -1 != settings.data.indexOf( 'remove-header' ) ) {
					/**
					 * Remove header image by clicking 'Hide image' button.
					 */					
					//console.log( "Remove header image by clicking 'Hide image' button" );
					api.deleteOptions();	
					api.init();
					return;
				} else if ( -1 != settings.data.indexOf( 'random-uploaded-image' ) ) {
					/**
					 * Remove header image by clicking 'Randomize uploaded headers' button.
					 */							
					//console.log( "Remove header image by clicking 'Randomize uploaded headers' button" );
					api.deleteOptions();	
					api.init();					
					return;
				} else {
					if ( -1 == settings.data.indexOf( 'action=heartbeat' ) ) {
						/** for testing purposes */
					}
				}				
			});			
		
		},
		_getOptions: function() {
			return WPGlobusHeaderImages.options;
		},
		getOptions: function() {
			var order = {};
			order['action'] = 'get_options';
			api.promise = api.promise.then(function () {
				return api.ajax(order);
			}).then(function (result) {

				WPGlobusHeaderImages.options = result.data.options;
				/**
				 * Now we need to set selectors from option @see WPGlobusHeaderImages.options
				 * accordingly with current order of images in customizer.
				 */
				var langs = []; 
				$.each( WPGlobusHeaderImages.options, function( lang, obj ){
					WPGlobusHeaderImages.options[lang]['active'] = false; 
					$( '.wpglobus-header-view' ).each( function( i, headerView ){
						var src = $( headerView ).find('img').attr('src');
						if ( WPGlobusHeaderImages.options[lang].img_data.url == src ) {
							WPGlobusHeaderImages.options[lang].sticker_data.selector 
								= WPGlobusHeaderImages.options[lang].sticker_data.selector.replace( '{{order}}', i );
							WPGlobusHeaderImages.options[lang].sticker_data.parentSelector 	
								= WPGlobusHeaderImages.options[lang].sticker_data.parentSelector.replace( '{{order}}', i );								
							
							WPGlobusHeaderImages.options[lang]['active'] = true; 
						}					
					});
				});
				
			});					
		},
		deleteOptions: function() {
			var order = {};
			order['action'] = 'delete';
			api.promise = api.promise.then(function () {
				return api.ajax(order);
			});				
		},
		save: function( order ) {

			if ( 'undefined' === typeof order ) {
				return;	
			}	
			order['action'] = 'save';

			api.promise = api.promise.then(function () {
				return api.ajax(order);
			}).then(function (result) {
				//result.data['spinner'] = result.data['spinner'].replace(/\\"/g, '"');
				//$(result.data['spinner']).css('visibility', '');
				api.getOptions();
				return;
			});				
		},
        beforeSend: function (order) {
			api.ajaxified = true;
            //$(order['spinner']).css('visibility', 'visible');
        },
        ajax: function (order) {
            return $.ajax({
                beforeSend: function () {
                    if ( 'undefined' === typeof api.beforeSend ) {
                        api.beforeSend(order);
                    }
                },
                type      : 'POST',
                url       : WPGlobusAdmin.ajaxurl,
                data      : {action: WPGlobusHeaderImages.process_ajax, order: order},
                dataType  : 'json'
            })
			.always(function (jqXHR, status){
				api.ajaxified = false;
			});	
        }
    };

    //noinspection JSUndeclaredVariable
    WPGlobusHeaderImages = $.extend({}, WPGlobusHeaderImages, api);
    WPGlobusHeaderImages.init();
});
