/**
 * WPGlobus Header Images
 * Interface JS functions
 *
 * @since 2.0.0
 *
 * @package WPGlobus Header Images
 */
/*jslint browser: true*/
/*jshint sub:true*/
/*global jQuery, console, WPGlobusAdmin, WPGlobusHeaderImages:true*/
jQuery(document).ready(function ($) {
    "use strict";

    if (typeof WPGlobusHeaderImages === 'undefined') {
        return;
    }

    var api = {
		promise: $.when(),
		stickerHtml: '<span class="language-sticker" data-sticker-id="{{sticker-id}}" data-language="{{language}}">{{caption}}</span>',
        init: function () {
			
			if ( WPGlobusHeaderImages.pagenow == 'customize.php' ) {
				api.openSection()
				api.addButton();
				api.addStickers();
			} else if ( WPGlobusHeaderImages.pagenow == 'upload.php' ) {
				api.setMenuItemLink();
				api.setImageItemLanguageSelector();
				api.attachListeners();
				api.debug();
			}
        },
		debug: function() {
			setTimeout(function(){
				$('#wpglobus-admin-debug-box').detach().insertAfter('#wpfooter');
				$('#wpglobus-admin-debug-box').css({'display':'block','margin-left':'200px'});
			}, 1000);
		},
		openSection: function() {
			if ( 'undefined' !== WPGlobusHeaderImages.get.section && 'header_image' === WPGlobusHeaderImages.get.section ) {
				setTimeout( function(){
					if ( 'undefined' !== wp.customize.section('header_image') ) {
						wp.customize.section('header_image').expand();
					}
				}, 500);
			}
		},
		addButton: function() {
			setTimeout( function(){
				$('<button type="button" class="button button-primary wpglobus-header-images">Set WPGlobus Header Images</button>').appendTo('#customize-control-header_image .actions');
				$(document).on('click', '.wpglobus-header-images', function(event){
					location.href = WPGlobusHeaderImages.link;
				});
			}, 1000);
		},
		addStickers: function() {
			var $container = $('#customize-control-header_image .container img');
			var sticker = WPGlobusHeaderImages.defaultSticker.replace('{{language}}', WPGlobusHeaderImages.enLanguageName[WPGlobusHeaderImages.defaultLanguage]);
			$(sticker).insertBefore($container);
			
			$('.header-view button').each( function(i, e) {
				var btn = $(e);
				if ( btn.hasClass('thumbnail') ) {
					var data = btn.data('customize-header-image-data');
					if ( 'undefined' !== typeof data.attachment_id ) {
						if ( 'undefined' !== typeof WPGlobusHeaderImages.ids[data.attachment_id] ) { // !!!!!!
							var language = WPGlobusHeaderImages.ids[data.attachment_id];
							var sticker = WPGlobusHeaderImages.sticker.replace('{{language}}', WPGlobusHeaderImages.enLanguageName[language]);
							$(sticker).insertBefore(btn);
							btn.parent('.header-view').css({'border':'2px #0085ba solid', 'border-top-left-radius':'10px','border-top-right-radius':'10px'});
						}
					}
				}
			});
		},
		setImageItemLanguageSelector: function() {
			$.each( WPGlobusHeaderImages.images, function(id, data) {
				var html = $('#post-'+id+' .post-state').html() + '&nbsp;';
				var select = '';
				if ( id == WPGlobusHeaderImages.defaultHeaderImageId ) {
					select = WPGlobusHeaderImages.defaultSelect;
				} else {
					select = WPGlobusHeaderImages.select;
				}
				select = select.replace( /{{post-id}}/g, id );
				select = select.replace( '{{language}}', data.language );
				select = select.replace( '{{selected-'+data.language+'}}', 'selected' );
				select = select.replace( /{{selected-.{2}}}/g, '' );
				$('#post-'+id+' .post-state').html(html+select);
				
				var imageData = {};
				imageData.attachment_id = id;
				imageData.url 			= data.url;
				imageData.thumbnail_url = data.thumbnail_url;
				imageData.width			= data.width;
				imageData.height 		= data.height ;
				$('#wpglobus-header-images-select-'+id).data('customize-header-image-data', imageData);
			});
			
			$('.wpglobus-header-images-select').each(function(idx,elm) {
				var currentId = $(this).data('id');
				var language = $(this).data('language');
				if ( language != WPGlobusHeaderImages.defaultLanguage ) {
					$('.wpglobus-header-images-select').each(function(i,e) {
						var id = $(e).data('id');
						if ( id != currentId ) {
							$('#wpglobus-header-images-select-'+id+' option[value="'+language+'"]').attr('disabled','disabled');
						}
					});
				}
			});			
			
		},
		setMenuItemLink: function() {
			if ( -1 != location.href.indexOf(WPGlobusHeaderImages.link) ) {
				$('#menu-media .wp-submenu li').removeClass('current');
			}
			$('#menu-media .wp-submenu li a').each( function(i,e){
				var link = $(e).attr('href');
				if ( WPGlobusHeaderImages.dummyLink == link ) {
					$(e).attr('href', WPGlobusHeaderImages.link);
					if ( -1 != location.href.indexOf(WPGlobusHeaderImages.link) ) {
						$(e).parent('li').addClass('current');
					}
					return false;
				}
			})
		},
		attachListeners: function() {
			$(document).on('change', '.wpglobus-header-images-select', function(event) {

				var currentId 	= $(this).data('id');
				var value 	 	= $(this).val();
				var language 	= '';
				var prevLanguage = '';
				if ( 'reset-select' == value ) {
					language = $(this).data('language');
					$(this).data('language', '');
					$('.wpglobus-header-images-select').each(function(i,e) {
						var id = $(e).data('id');
						if ( id != currentId ) {
							$('#wpglobus-header-images-select-'+id+' option[value="'+language+'"]').removeAttr('disabled');
						}
					});
				} else {
					language = value;
					prevLanguage = $(this).data('language');
					if ( 'undefined' !== typeof prevLanguage && '' != prevLanguage ) {
						api.ajax(currentId, 'reset-select', prevLanguage);
						$('.wpglobus-header-images-select').each(function(i,e) {
							var id = $(e).data('id');
							if ( id != currentId ) {
								$('#wpglobus-header-images-select-'+id+' option[value="'+prevLanguage+'"]').removeAttr('disabled');
							}
						});						
					}
					$(this).data('language', language);
					$('.wpglobus-header-images-select').each(function(i,e) {
						var id = $(e).data('id');
						if ( id != currentId ) {
							$('#wpglobus-header-images-select-'+id+' option[value="'+language+'"]').attr('disabled','disabled');
						}
					});
				}
				api.ajax(currentId, value, language);
			});
		},
		beforeSend: function(order) {
		},
		ajax: function(currentId, orderSelect, language) {

			api.promise = api.promise.then( function() {

				var order = {};
				if ( 'reset-select' == orderSelect ) {
					order['action'] = 'delete_option';
				} else {
					order['action'] 	= 'save';
					order['sticker'] 	= orderSelect;
				}
				order['img_data'] 	= $('#wpglobus-header-images-select-'+currentId).data('customize-header-image-data');
				order['language'] 	= language;
				
				return $.ajax({
					beforeSend:function(){
						if ( typeof api.beforeSend !== 'undefined' ) api.beforeSend(order);
					},
					type: 'POST',
					url: WPGlobusHeaderImages.ajaxurl,
					data: {action: WPGlobusHeaderImages.process_ajax, order: order},
					dataType: 'json' 
				});					
			}, function(){
				/* error in promise */
				/* return $.ajax( ); */
			}).then( function( result ) {
			});			
		}
    };

    //noinspection JSUndeclaredVariable
    WPGlobusHeaderImages = $.extend({}, WPGlobusHeaderImages, api);
    WPGlobusHeaderImages.init();
});
